<?php

namespace Plugins\WidgetBuilder\Widgets;


use App\Facades\GlobalLanguage;
use Plugins\PageBuilder\Fields\Repeater;
use Plugins\PageBuilder\Helpers\RepeaterField;
use Plugins\WidgetBuilder\Traits\LanguageFallbackForWidgetBuilder;
use Plugins\WidgetBuilder\WidgetBase;


class TenantHotelBookingSocialWidget extends WidgetBase
{
    use LanguageFallbackForWidgetBuilder;
    public function admin_render()
    {
        $output = $this->admin_form_before();
        $output .= $this->admin_form_start();
        $output .= $this->default_fields();

        $widget_saved_values = $this->get_settings();

        $output .= $this->admin_language_tab();
        $output .= $this->admin_language_tab_start();

        $all_languages = GlobalLanguage::all_languages(1);

        foreach ($all_languages as $key => $lang) {
            $output .= $this->admin_language_tab_content_start([
                'class' => $key == 0 ? 'tab-pane fade show active' : 'tab-pane fade',
                'id' => "nav-home-" . $lang->slug
            ]);

            $output .= $this->admin_language_tab_content_end();
        }

        //repeater
        $output .= Repeater::get([
            'settings' => $widget_saved_values,
            'id' => 'tenant_hotel_booking_social_widget_one',
            'fields' => [
                [
                    'type' => RepeaterField::TEXT,
                    'name' => 'repeater_icon',
                    'label' => __('Icon Class')
                ],
                [
                    'type' => RepeaterField::TEXT,
                    'name' => 'repeater_image_url',
                    'label' => __('Icon URL')
                ],

            ]
        ]);


        $output .= $this->admin_language_tab_end();

        $output .= $this->admin_form_submit_button();
        $output .= $this->admin_form_end();
        $output .= $this->admin_form_after();

        return $output;
    }


    public function enable(): bool
    {
        return true; // TODO: Change the autogenerated stub
    }

    public function frontend_render()
    {
        $repeader_data = $this->setting_item('tenant_hotel_booking_social_widget_one') ?? [];


        $social_markup = '';
        foreach ($repeader_data['repeater_image_url_'] ?? [] as $key =>  $item)
        {
            $repeater_url = $repeader_data['repeater_image_url_'][$key] ?? '';
            $repeater_icon = $repeader_data['repeater_icon_'][$key] ?? '';

            $social_markup.= <<<MARKUP

                <li class="footer-widget-social-list-item">
                    <a class="footer-widget-social-list-link" href="{$repeater_url}"> <i class="{$repeater_icon}"></i> </a>
                </li>

            MARKUP;
        }

        return <<<HTML
        <div class="footer-widget widget">
            <div class="footer-widget-social mt-4">
                  <ul class="footer-widget-social-list list-style-none justify-content-center">
                {$social_markup}
                  </ul>
            </div>
        </div>
        HTML;

    }

    public function widget_title(){
        return __('Hotel Booking Social Widget');
    }

    public function columnClass(){
        return 'col-xxl-3 col-xl-3 col-lg-4 col-md-6 col-sm-8';
    }

}
